/************************************************************************************************************\

Module Name:    RtspClientModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_RTSPCLIENTMODULE_H
#define INC_RTSPCLIENTMODULE_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleLink.h"
#include "ModuleThread.h"
#include "LNetStreamer.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      AudioSpecificCfg

\************************************************************************************************************/
typedef struct tagAudioSpecificCfg
{
    MBOOL   bValid;
    MUINT16 uiCfg;
} AudioSpecificCfg;

/************************************************************************************************************\

Structure:      RtspClientModule

\************************************************************************************************************/
typedef struct tagRtspClientModule
{
    MBOOL                   bEnableVideo;
    ModuleLink              oVideoOutLink;
    ModuleThread            oMainCpuThread;
    LNetStreamer_Handle     hSession;
    MBOOL                   bLostConnection;
    MBOOL                   bEnableAudio;
    ModuleLink              oAudioOutLink;
    ModuleThread            oChildCpuThread;
    AudioSpecificCfg        oAudioCfg;
    MCHAR8                  szLocation[256];
    MCHAR8                  szMcastAddr[64];
    MCHAR8                  szSdp[512];
    MCHAR8                  szNetInterface[128];
    LNetStreamer_Config     oConfig;
    MCHAR8                  szModuleName[16];
} RtspClientModule;

#define RtspClientModule_Construct { /*.bEnableVideo            =*/ MFALSE, \
                                     /*.oVideoOutLink           =*/ ModuleLink_Construct, \
                                     /*.oMainCpuThread          =*/ ModuleThread_Construct, \
                                     /*.hSession                =*/ MNULL, \
                                     /*.bLostConnection         =*/ MFALSE, \
                                     /*.bEnableAudio            =*/ MFALSE, \
                                     /*.oAudioOutLink           =*/ ModuleLink_Construct, \
                                     /*.oChildCpuThread         =*/ ModuleThread_Construct, \
                                     /*.oAudioCfg               =*/ {0}, \
                                     /*.szLocation              =*/ {0}, \
                                     /*.szMcastAddr             =*/ {0}, \
                                     /*.szSdp                   =*/ {0}, \
                                     /*.szNetInterface          =*/ {0}, \
                                     /*.oConfig                 =*/ {0}, \
                                     /*.szModuleName            =*/ ""}

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus RtspClnMod_Init(RtspClientModule*       poRtspClnMod,
                        LDevice_Handle          hDevice,
                        MBOOL                   bEnableVideo,
                        MBOOL                   bEnableAudio,
                        MUINT                   uiVideoBufferCount,
                        MUINT                   uiVideoBufferSizeBytes,
                        MUINT                   uiAudioBufferCount,
                        MUINT                   uiAudioBufferSizeBytes,
                        LNetStreamer_Protocol   eProtocol,
                        const char*             szLocation,
                        const char*             szAddress,
                        MUINT                   uiVideoPort,
                        MUINT                   uiAudioPort,
                        MBOOL                   bSkipToNextIdr,
                        MUINT                   uiAudioSampleRate,
                        MUINT                   uiMtu,
                        MBOOL                   bEnableSrt,
                        const char*             szNetInterface,
                        MBOOL                   bEnableIpv6,
                        LNetStreamer_SrtMode    eSrtMode);
void    RtspClnMod_Cleanup(RtspClientModule* poRtspClnMod);
LStatus RtspClnMod_Start(RtspClientModule* poRtspClnMod);
void    RtspClnMod_Stop(RtspClientModule* poRtspClnMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_RTSPCLIENTMODULE_H
